/************************************************************/
/* Copyright (c) Matsushita Electric Industrial Co.,Ltd.    */
/* All rights reserved                                      */
/* Copyright (c) 2008-2009 Panasonic Corporation			*/
/* All Rights Reserved.										*/
/*  ŏIXV	: 2009/3/16									*/
/************************************************************/


#include <sd_api.h>
#include <sdpnp_api.h>
#include "sdds_main.h"
#include "sdds_ioctl.h"


static BOOL CARDINIT_flag;
#define SD_INFO1_WRITEPROTECT	0x0080

////////////////////////
// SD_DS_IOC_GETPARAM //
////////////////////////
int DS_P_getparam(struct SD_PNP_device *dev, ULONG arg)
{

	int	ret = 0;
	USHORT	status, status_tmp;
#if 0	/* 20120905 Delete */
	struct	CARD_PARAM  card_param;	// CARD_PARAMsdpnp_api.hŒ`
#endif
	CARD_PARAM  card_param;	// CARD_PARAMsdpnp_api.hŒ`
	unsigned long ulDummy;	//20120905 Added

	/* J[h񏉊 */
	card_param.CARD_distinction		= NO_CARD;	// 0xFF
	card_param.MEMORY_Info.CARD_Size	= 0;
	card_param.MEMORY_Info.BLOCK_Size	= 0;
	card_param.MEMORY_Info.SECTOR_Size	= 0;
	card_param.MEMORY_Info.WRITE_Protect	= MEMORY_PROTECTED;	// 1
	card_param.SDINIT_flag = 0;		// J[hۃtONA


	/* J[hȂmF */
	ret = SD_F_Ioctl(dev->fd, SD_IOC_GET_STATUS, (ULONG)&status);
	if(ret){
		printk("Fault of SD_IOC_GET_STATUS(err=%x)\n",ret);
		return -EIO;
	}
	status_tmp = status;

	/* J[h */
#if IO3
	if(!(status & 0x0400))	/* SD Card detect Check on DAT3 Line at port0 */
#else
	/* bit5	card_detectio0j */
	if(!(status & 0x0020))	/* SD Card detect Check on CD Line at port0 */
#endif
	{
		/* J[hoꂽSDJ[hƔf */
		card_param.CARD_distinction = MEM_SD;

		/* J[hς */
		if(CARDINIT_flag == 0) {
			/* J[hۂCARD_PARAM\̂֔f */
			card_param.SDINIT_flag = 0;

			/* Card Size */
			ret = SD_F_Ioctl(dev->fd, SD_IOC_GET_CARDSIZE, (ULONG)&card_param.MEMORY_Info.CARD_Size);
			if(ret){
				printk("Falut of SD_IOC_GET_CARDSIZE\n");
				return -EIO;
			}
			/* Block/Sector Size */
			card_param.MEMORY_Info.BLOCK_Size = 0;
			card_param.MEMORY_Info.SECTOR_Size = 512	/*SECTOR_SIZE*/;
			/* Write Protect */
			card_param.MEMORY_Info.WRITE_Protect = (ULONG)((status & BIT_CARD_PROTECT) >> 8);	// 1WriteEnableA0WriteProtect
		}
		 /* J[h */
		else
		{
			card_param.SDINIT_flag = 1;
		}
	}

	/* card_paramargcopy */
#if 0	/* 20120905 Delete */
	__copy_to_user((struct CARD_PARAM *)arg, &card_param, sizeof(struct CARD_PARAM));
#endif
	ulDummy = __copy_to_user((CARD_PARAM *)arg, &card_param, sizeof(CARD_PARAM));
	
	return 0;
}

////////////////////
// SD_DS_IOC_INIT //
////////////////////
int DS_P_card_init(struct SD_PNP_device *dev, ULONG arg)
{
	int ret = 0;

	CARDINIT_flag = 1;		// J[hsitOPj

//@2009.8.26	ret = SD_F_Ioctl(dev->fd, SD_IOC_SET_INIT, 0);	// ֐s
	ret = SD_F_Ioctl(dev->fd, SD_IOC_SET_INIT, arg);	// ֐s

	if(ret){
		/* J[hsʒm */
		printk("SD_DS: SD_IOC_SET_INIT failure in DS_P_card_init\n");
		return -EIO;
	}

	if(arg == 0x02){	/* J[h̏ꍇ */
		CARDINIT_flag = 0;	// SDJ[hۃtÕNA -> J[h
	}

	return ret;
}

//////////////////////
// SD_DS_IOC_DETECT //
//////////////////////
int DS_P_detect(struct SD_PNP_device *dev, ULONG arg){

//	unsigned long flags;
//	static spinlock_t PnP_decect;          /* XsbN */ //20091203
	int event;

//	spin_lock_irqsave(&(PnP_decect),flags);   //  spin_lock //20091203

	if(!dev->pending){	// 荞݂Ȃ
		interruptible_sleep_on(&dev->irq_wait);	// 荞ݑ҂Sleep
	}
	dev->pending = 0;	// 荞݃tONA
	event = dev->card_event;

	/* card_eventargcopy */
//	spin_unlock_irqrestore(&(PnP_decect),flags); //  spin_lock //20091203

	if( event == SD_CARD_REMOVE ){	// J[hrȍꍇ
		CARDINIT_flag = 1;		// SDJ[hۃtÕNA -> J[hs
	}

	/* card_eventԂ */
	return event;
}

//////////////////////
// SD_DS_IOC_INSDEL //
//////////////////////
int DS_P_insdel(struct SD_PNP_device *dev, ULONG arg){

	int	ret = 0;
	STR_SD_SET_INSDEL_INTR	pstrArg;
	unsigned long ulDummy;	// 20120905 Added

	/* argulIntrփRs[(argTRUE or FALSE) */
#if 0	/* 20120905 Delete */
	__copy_from_user(&pstrArg.ulIntr, (BOOL *)arg, sizeof(BOOL));
#endif
	ulDummy = __copy_from_user(&pstrArg.ulIntr, (BOOL *)arg, sizeof(BOOL));
	
	ret = SD_F_Ioctl(dev->fd, SD_IOC_SET_INSDEL_INTR, (ULONG)&pstrArg);
	if(ret){
		printk("SD_DS: SD_IOC_SET_INSDEL_INTR failure in DS_P_card_init\n");
		return -EIO;
	}

	return 0;
}
